unit CLassCatalog;
// ======================================================================
interface
// ======================================================================
uses
// --------------------------------
//     
Windows, Messages, SysUtils, Variants, Classes,
Graphics, Controls, Forms, Dialogs,
// --------------------------------
Contnrs,
ImgList, Clipbrd, Printers,
IniFiles, Registry,
Jpeg, Math,
// --------------------------------
//   Standard
Menus, StdCtrls, ActnList,
// --------------------------------
//   Additional
Buttons, Mask, Masks, Grids, ExtCtrls, {Forms, StdCtrls,}
DbLogDlg, CheckLst, AppEvnts, ValEdit,
TeeProcs, TeEngine, TeCanvas, Chart,
//   Additional (XP - )
XPStyleActnCtrls, ActnMan, ToolWin, ActnCtrls, ActnMenus,
ActnColorMaps, CustomizeDlg,
// --------------------------------
//   Win32
ComCtrls, {Controls,}
//   Win32 (XP - )
 XPMan,
// --------------------------------
//   System
{ExtCtrls,} MPlayer, OleCtnrs, DDEMan,
// --------------------------------
//   Dialogs
{Dialogs,} ExtDlgs,
// --------------------------------
//   Win31
Dblookup, Tabs, Outline, TabNotBk, {ExtCtrls,} FileCtrl,
// --------------------------------
//    Samples
Gauges, ColorGrd, Spin, DirOutln, Calendar, IBCtrls,
ShellCtrls,
// --------------------------------
//   Data Access
Db, DBClient, Provider, xmldom, Xmlxform,
// --------------------------------
//   Data Control
DBCtrls, DBGrids, DBCGrids, DbChart,
// --------------------------------
//   dbExpert
DBXpress, SqlExpr, SimpleDS,
// --------------------------------
//   DataSnap
MConnect, SConnect, ObjBrkr, TConnect,
// --------------------------------
//   BDE
DBTables,
// --------------------------------
//   ADO
ADODB,
// --------------------------------
//   InterBase
IBTable, IBQuery, IBStoredProc, IBDatabase,
IBUpdateSQL, IBCustomDataSet, IBSQL, IBDatabaseInfo,
IBSQLMonitor, IBEvents, IBExtract, DBLocal, DBLocalI,
// --------------------------------
//   WebServices
SOAPHTTPClient, SOAPHTTPTrans,
// --------------------------------
//   Internet Express
MidProd, WebBroker, DBBdeWeb,
// --------------------------------
//   Internet
HTTPProd, CGIApp, CGIHTTP, DBXpressWeb,
Sockets, SHDocVw,
// --------------------------------
//   WebSnap
WebAdapt, WebComp, DBAdapt, WebDisp, WebUsers, XMLIntf,
msxmldom, XMLDoc, XSLProd, CompProd, PagItems, SiteProd,
// --------------------------------
//   Decision Cube
Mxstore, MXDB, MXTABLES, MXPIVSRC, MXGRID, MXGRAPH,
// --------------------------------
//   ActiveX (OLE 2 Interface Unit)
ActiveX, ComObj, AxCtrls, OleCtrls, OleConst,
Chartfx3, VCSpell3, VCF1, VCFI,
// --------------------------------
//   Rave
RpDefine, RpRave, RpBase, RpSystem, RpFiler, RpCon,
RpConDS, RpConBDE, RpRender, RpRenderCanvas, RpRenderPreview,
RpRenderPrinter, RpRenderPDF, RpRenderHTML, RpRenderRTF,
RpRenderText,
// --------------------------------
//   Indy Clients
IdBaseComponent, IdComponent, IdTCPConnection,  IdTCPClient,
IdIntercept, IdIOHandler, IdDayTime, IdUDPBase, IdUDPClient,
IdDayTimeUDP, IdDNSResolver, IdEcho, IdEchoUDP,
IdFinger, IdFTP, IdGopher, IdHTTP, IdCookieManager,
IdHTTPHeaderInfo, IdHeaderList,  IdRawBase, IdRawClient,
IdIcmpClient, IdMessageClient, IdIMAP4, IdPOP3, IdIdent,
IdIPMCastBase, IdIPMCastClient, IdSocketHandle, IdIRC,
IdLPR, IdNNTP, IdQotd, IdQOTDUDP, IdRemoteCMDClient,
IdRexec, IdRSH, IdSMTP, IdSNMP, IdSNPP, IdSNTP, IdSysLog,
IdTelnet, IdTime, IdTimeUDP, IdTrivialFTP, IdWhois,
//   Indy Servers
IdTCPServer, IdRFCReply, IdServerIOHandler, IdThreadMgr,
IdUDPServer, IdChargenServer, IdChargenUDPServer,
IdDayTimeServer, IdDayTimeUDPServer, IdDICTServer, IdDiscardServer,
IdDiscardUDPServer, IdEchoServer, IdEchoUDPServer, IdFingerServer,
IdFTPServer, IdUserAccounts, IdGopherServer, IdHTTPServer,
IdIdentServer, IdIMAP4Server, IdIPMCastServer, IdIRCServer,
IdMappedPortTCP, IdMappedFTP, IdMappedPortUDP, IdNNTPServer,
IdPOP3Server, IdQOTDServer, IdQotdUDPServer, IdRexecServer,
IdRSHServer, IdSimpleServer, IdSMTPServer, IdSyslogServer,
IdTelnetServer, IdTimeServer, IdTimeUDPServer, IdTrivialFTPServer,
IdTunnelMaster, IdTunnelSlave,
// --------------------------------
//   Indy Intercepts
IdBlockCipherIntercept, IdCompressionIntercept, IdLogDebug,
IdLogEvent, IdLogFile, IdLogStream,
// --------------------------------
//   Indy I/O Handlers
IdSocks, IdIOHandlerSocket, IdIOHandlerStream, IdIOHandlerThrottle,
IdServerIOHandlerSocket, IdSSLOpenSSL,
// --------------------------------
//   Indy Misc
IdAntiFreeze, IdCoder, IdCoder3to4, IdCoderMIME, IdCoderUUE,
IdCoderQuotedPrintable, IdDateTimeStamp, IdCoderXXE,
IdIPWatch, IdHL7, IdMailBox, IdMessage, IdEMailAddress,
IdMessageCoder, IdMessageCoderMIME, IdNetworkCalculator,
IdSysLogMessage, IdThreadComponent, IdThreadMgrDefault,
IdThreadMgrPool, IdVCard,
// --------------------------------
//   COM+
OleServer, CmAdmCtl,
// --------------------------------
//   InterBase Admin
IBServices, IBInstall,
// --------------------------------
//   IW Standard, IW Data, IW CLient Side
// IW Client Control  ,   
//    .
// --------------------------------
//   Servers
Word2000, Excel2000, MSPpt2000,
Outlook2000, Access2000, Binder2000,
//------------------------------
// 
ScktComp, ComServ, syncobjs, httpapp, dbweb,  DsIntf,
Nsapi, Isapi, isapiapp, ISAPIHTTP, MidasCon,

//------------------------------
//   
{DesignIntf, DesignEditors,}
//------------------------------
TypInfo;

// ======================================================================

const MaxIndex = 811 - 40;
type  TClassArray = array [1..MaxIndex] of TClass;
const ClassArray: TClassArray = (

// =======================================================================
//  
TObject, SysUtils.Exception, TPersistent, TComponent, TControl, TWinControl,
TApplication, TApplicationEvents,
// =======================================================================
//   Exception
EAbort, EAccessViolation, EAssertionFailed, EBitsError, EClassNotFound,
EComponentError, EControlC, EConvertError, EDatabaseError, EDateTimeError,
EDBClient, EDBEditError, EDBEngineError, EDivByZero, EExternalException,
EFCreateError, EFilerError, EFOpenError, EIBError, EInOutError,
EIntError, EIntfCastError, EIntOverflow, EInvalidArgument, EInvalidCast,
EInvalidContainer, EInvalidGraphic, EInvalidGraphicOperation,
EInvalidGridOperation, EInvalidImage, EInvalidInsert, EInvalidOp,
EInvalidOperation, EInvalidPointer, EListError, EMathError,
EMCIDeviceError, EMenuError, EMethodNotFound, ENoResultSet,
EOleCtrlError, EOleError, EOleException, EOleException, EOleSysError,
EOutlineError, EOutOfMemory, EOutOfResources, EOverflow, EPackageError,
EParserError, EPrinter, EPrivilege, EPropertyError, EPropReadOnly,
EPropWriteOnly, ERangeError, EReadError, EReconcileError, ERegistryException,
EResNotFound, ESocketError,  EStreamError, EStringListError,
EThread, ETreeViewError, EUnderflow, EUpdateError, EVariantError,
EWriteError, EZeroDivide,
{Deprecated}
EStackOverflow, EWin32Error,
// =======================================================================
//  ,    
//         
//   .

{System}
 TAggregatedObject, TContainedObject, TInterfacedObject,

{Classes}
 TCustomMemoryStream, TBits, TCollection, TCollectionItem, TDataModule,
 TFiler, TFileStream, THandleStream, TMemoryStream, TList, TParser,
 TReader, TResourceStream, TStream, TStringList, TStrings, TStringStream,
 TThread, TThreadList, TWriter, TBasicAction,

{Graphics}
 TGraphic, TGraphicsObject, TBitmap, TBitmapImage, TBrush,  TCanvas,
 TFont, TIcon, TIconImage, TMetafile, TMetafileCanvas, TMetafileImage,
 TPen, TPicture, TSharedImage,

{Controls, Tabs}
 TCustomControl, TControlCanvas, TDragControlObject, TGraphicControl,
 THintWindow,  TDragObject,  TSizeConstraints,
 TScroller, TTabSet, TTabList,

{Dialogs, ExtDlgs}
 TColorDialog, TCommonDialog, TFontDialog, TFindDialog, TOpenDialog,
 TPrintDialog, TPrinterSetupDialog, TReplaceDialog, TSaveDialog,
 TOpenPictureDialog, TSavePictureDialog,

{ComCtrls}
  TCustomTabControl, TCustomRichEdit, TCustomTreeView,
  TCustomUpDown, TConversion, TDateTimeColors, THeaderSection,
  THeaderSections, TIconOptions, TListColumn, TParaAttributes,
  TTabSheet, TTextAttributes,

 //--------------------------------------------------------------------
 {SyncObjs}
 TCriticalSection, TEvent, THandleObject, TSimpleEvent, TSynchroObject,

 {ScktComp}
 TCustomSocket, TCustomWinSocket, TCustomServerSocket,
 TClientSocket, TClientWinSocket, TServerAcceptThread,
 TServerClientThread, TServerClientWinSocket, TServerSocket,
 TServerWinSocket,

 {DBWeb}
 TDSTableProducer, TDSTableProducerEditor,
 TDataSetTableProducer, THTMLTableColumn, THTMLTableColumns, THTTPDataLink,

 {FileCtrl}
 TDirectoryListBox, TFileListBox,  TFilterComboBox, TDriveComboBox,
 TIniFile, TISAPIApplication,

 {Registry}
 TRegistry, TRegIniFile,

 {Provider}
 TCustomProvider, TProvider,

{HTTPApp}
 TCustomWebDispatcher, TWebActionItem, TWebActionItems, TWebDispatcher,
 TWebModule, TWebRequest, TWebResponse,

{==========  ===========}
 {Contnrs}
 TComponentList,
 {ImgList}
 TCustomImageList,  TChangeLink,
 {Printer,}
 TPrinter,
 {Variants}
 TCustomVariantType,
 {JPeg}
 TJPEGImage,

 {Outline - Deprecated}
 TCustomOutline, TOutline, TOutlineNode, OutlineError,

 {TabNotBk}
 TTabbedNotebook, TTabPage,

 // -------------------
 TComServer,
 TRemoteServer,

 // ==========================
 {ISAPI}
 TISAPIRequest,
 TISAPIResponse,
// -------------------
 {WebBroker}
 TWebApplication,
 TWinCGIRequest,
 TWinCGIResponse,
 {CGIApp}
 TCGIApplication,
 {CGIHTTP}
 TCGIRequest,
 TCGIResponse,
 // -------------------

 // ===================
 //   Standard
 {Forms}
 TCustomForm, TForm, TScreen, TScrollingWinControl, TControlScrollBar,
 TFrame, TScrollBox,
 {Menu}
 TMainMenu, TPopupMenu, TMenu, TMenuItem,
 {StdCtrls}
 TLabel,  TEdit, TMemo, TButton, TCheckBox,
 TListBox, TComboBox, TScrollBar,  TGroupBox,
 {StdCtrls}
 TCustomMemo, TCustomEdit, TCustomCheckBox, TCustomComboBox,
 TCustomGroupBox,  TCustomLabel, TCustomListBox,
 TCustomCheckBox, TCustomComboBox, TButtonControl, TRadioButton,
 {ExtCtrls}
 TCustomPanel, TCustomRadioGroup, TRadioGroup, TPanel,
 {ActnList}
 TActionList,
 // ===================
 //   Additional
 {Buttons, Masks}
 TBitBtn, TSpeedButton, TMask, TCustomMaskEdit, TMaskEdit,
 {Grids}
 TCustomGrid, TStringGrid, TDrawGrid, TInplaceEdit,
 TStringGridStrings,
 {StdCtrls}
 TCustomStaticText, TStaticText,
 {ExtCtrls}
 TImage, TShape, TBevel, TSplitter,  TControlBar,
 THeader, TNotebook, TLabeledEdit, TColorBox,
 {ValEdit}
 TValueListEditor,
 {Chart}
 TChart,  TChartWall,  TChartTitle, TChartLegend, TChartAxis,
 TChartGradient,  TChartPen, TChartBrush, TChartAxisPen,
 TDottedGrayPen, TChartHiddenPen, TDarkGrayPen, TChartAxisTitle,
 {CheckLst}
 TCheckListBox,
 {ActnMan} {-}
 TActionManager, TActionBars, TActionListCollection, TActionBarStyle,
 TActionMainMenuBar, TActionToolBar, TXPColorMap, TStandardColorMap,
 TTwilightColorMap, TCustomizeDlg,
 TXPManifest,
 // ===================
 //   Win32
 TTabControl, TPageControl, TPage, TImageList, TListColumns,
 TListItem, TListItems, TListView, TRichEdit,  TTrackBar,
 TProgressBar, TUpDown, THotKey, TAnimate,  TDateTimePicker,
 TMonthCalendar, TTreeView, TTreeNode, TTreeNodes, THeaderControl,
 TStatusBar, TStatusPanel, TStatusPanels, TToolBar, TToolButton,
 TCoolBar, TCoolBand, TPageScroller, TComboBoxEx, TComboExItems,
 {*Customs}
 TCustomListView, TCustomHotKey,
 // ===================
 //   System
 TTimer, TPaintBox, TMediaPlayer,
 {OleCtnls, OleCtrls}
 TOleContainer, TOleForm, TOleControl, TEnumPropDesc,  TEventDispatch,
 {Clpbrd}
 TClipboard,
 {DBeMan}
 TDdeClientConv, TDdeClientItem, TDdeMgr, TDdeServerConv,
 TDdeServerItem,
 // ===================
 //   Data Access
 {DB}
 TAutoIncField,  TBinaryField,  TBlobField, TBooleanField, TBytesField,
 TCheckConstraint, TCheckConstraints, TCurrencyField, TBCDField,
 TDataLink, TDataSource, TDataSet, TDataSetDesigner, TDateField,
 TDateTimeField, TField, TFieldDef, TFieldDefs, TFloatField, TGraphicField,
 TIndexDef, TIndexFiles, TMemoField, TIntegerField, TNumericField,
 TParam, TParams, TSmallintField, TStringField,  TTimeField,
 TVarBytesField, TWordField, TLookupList, TLoginDialog,
 {DBClient}
 TCustomRemoteServer, TClientDataSet, TConnectionBroker,
 {Xmlxform}
 TXMLTransformProvider, TXMLTransform, TXMLTransformClient,
 // ===================
 //   Data Controls
 {DBCtrls}
 TDBNavigator, TNavButton,  TNavDataLink,
 TDBText, TDBEdit, TDBMemo, TDBImage,  TDBListBox, TDBComboBox,
 TDBCheckBox, TDBRadioGroup, TDBLookupListBox, TDBLookupComboBox,
 TDBRichEdit, TDBLookupControl, TDataSourceLink, TFieldDataLink,
 TListSourceLink, TPaintControl, TPopupDataList,
 {DBGrids}
 TCustomDBGrid, TDBGrid, TDBCtrlPanel,  TDBCtrlGridLink,
 TDBGridColumns, TBookmarkList, TColumn, TColumnTitle, TGridDataLink,
 {DBCGrids, DBChart}
 TDBCtrlGrid, TDBChart,
 {DBTables}
 TDBDataSet, TDBError,
 {DbLookUp}
 TDBLookupCombo, TDBLookupList, TPopupGrid, TComboButton,

 // ===================
 //   DataSnap
 {SqlExpr}
 TSQLConnection, TSQLDataSet, TSQLQuery, TSQLStoredProc, TSQLMonitor,
 {SimpleDS}
 TSimpleDataSet,
 {MConnect, SConnect, TConnect }
 TDCOMConnection, TSharedConnection,
 TSocketConnection, TWebConnection,
 TLocalConnection,
 {ObjBrkr}
 TSimpleObjectBroker,

 // ===================
 //   BDE
 {DBTables}
 TDatabase, TBatchMove, TBDECallback, TBDEDataSet,
 TBlobStream, TDataSetUpdateObject, TParamList, TQuery,
 DBTables.TSession, TSessionList, TStoredProc, TTable, TUpdateSQL,

 // ===================
 //   ADO
 TADOConnection, TADOCommand, TADODataSet, TADOTable,
 TADOQuery, TADOStoredProc, TRDSConnection,

 // ===================
 //   InterBase Admin
 TIBComponent,
 TIBTable,
 TIBQuery,
 TIBStoredProc,
 TIBDatabase,
 TIBTransaction,
 TIBUpdateSQL,
 TIBDataSet,
 TIBSQL,
 TIBDatabaseInfo,
 TIBSQLMonitor,
 TIBEvents,
 TIBExtract,
 TIBClientDataSet,
 TAggregates,
 TIBGeneratorField,
 TServerCollection,
 //
 TAdapter,
 TPagedAdapter,
 TDataSetAdapter,
 TLoginFormAdapter,
 TAdapterDefaultFields,
 TAdapterDefaultActions,
 TStringsValuesList,
 TDataSetValuesList,
 TWebAppComponents,
 TApplicationAdapter,
 TEndUserAdapter,
 TEndUserSessionAdapter,
 TPageDispatcher,
 TAdapterDispatcher,
 TLocateFileService,
 TWebUserList,
 TWebUserItems,
 TXSLPageProducer,
 TDOMVendor,
 TAdapterPageProducer,
 TWebComponentList,

 // ===================
 //   Decision Cube
 TDecisionCube,
 TCubeDims,
 TDecisionQuery,
 TDecisionSource,
 TDecisionPivot,
 TDecisionGrid,
 TDisplayDims,
 TDecisionGraph,


 // ===================
 //   Internet
 TPageProducer, TCustomPageProducer,  THTMLTableAttributes,
 THTMLTableCellAttributes, THTMLTableElementAttributes,
 THTMLTableHeaderAttributes, THTMLTableRowAttributes,
 THTMLTagAttributes, TQueryTableProducer, TSQLQueryTableProducer,
 TTcpClient,  TTcpServer, TUdpSocket, TXMLDocument, TWebBrowser,

 // ===================
 //   Samples
 TGauge, TSpinButton, TColorGrid, TSpinEdit, TTimerSpeedButton,
 TDirectoryOutline, TCalendar, TIBEventAlerter, TShellTreeView,
 TShellComboBox, TShellListView, TShellChangeNotifier,
 
 // ===================
 //   ActiveX
 TChartfx,
 TVSSpell,
 TF1Book,
 TVtChart,
 AxCtrls.TPropertyPage,
 TOleGraphic, TOleStream, TConnectionPoint, TConnectionPoints,
 TCustomAdapter, TPictureAdapter, TStringsAdapter, TFontAdapter,
 TActiveForm, TActiveFormControl, TActiveFormFactory,
 TActiveXControl, TActiveXControlFactory, TActiveXPropertyPage,
 TActiveXPropertyPageFactory, TAdapterNotifier,

 // ===================
 //   Rave
 TRvProject, TRvSystem, TSystemFiler, TSystemPreview, TSystemPrinter,
 TRvNDRWriter, TRvCustomConnection, TRvDataSetConnection,
 TRvTableConnection, TRvQueryConnection, TRvRenderPreview,
 TRvRenderPrinter, TRvRenderPDF, TRPPDFDocInfo, TRvRenderHTML,
 TRvRenderRTF, TRvRenderText,

 // ===================
 // INDY
 //   Indy Clients
 TIdTCPClient, TIdConnectionIntercept,  TIdIOHandler,  TIdUDPClient,
 TIdDayTime,  TIdDayTimeUDP,  TIdDNSResolver,  TIdEcho,   TIdEchoUDP,
 TIdFinger,  TIdFTP, TIdFtpProxySettings, TIdGopher,  TIdHTTP,
 TIdHTTPRequest, TIdHeaderList, TIdCookieManager, TIdProxyConnectionInfo,
 TIdIcmpClient, TIdIdent, TIdIMAP4, TIdIPMCastClient, TIdSocketHandles,
 TIdIRC, TIdIRCReplies, TIdLPR, TIdLPRControlFile, TIdNNTP, TIdPOP3,
 TIdQOTD, TIdQOTDUDP, TIdRexec, TIdRSH, TIdSMTP, TIdSNMP, TIdSNPP,
 TIdSNTP, TIdSysLog, TIdTelnet, TIdTime, TIdTimeUDP, TIdTrivialFTP,
 TIdWhois,
//   Indy Servers
 TIdTCPServer, TIdCommandHandlers, TIdRFCReply, TIdRFCReplies,
 TIdServerIntercept, TIdServerIOHandler, TIdThreadMgr,
 TIdUDPServer, TIdChargenServer, TIdChargenUDPServer,
 TIdDayTimeServer, TIdDayTimeUDPServer, TIdDICTServer,
 TIdDISCARDServer, TIdDiscardUDPServer, TIdECHOServer,
 TIdEchoUDPServer, TIdFingerServer, TIdFTPServer,
 TIdUserManager, TIdUserAccounts, TIdGopherServer,
 TIdHTTPServer, TIdIdentServer, TIdIMAP4Server,
 TIdIPMCastServer, TIdIRCServer, TIdMappedFTP, TIdMappedPop3,
 TIdMappedPortTCP, TIdMappedPortUDP, TIdMappedTelnet,
 TIdNNTPServer, TIdPOP3Server, TIdQOTDServer, TIdQotdUDPServer,
 TIdRexecServer, TIdRSHServer, TIdSimpleServer, TIdSMTPServer,
 TIdSMTPMessages,  TIdSMTPGreeting, TIdSMTPRcpReplies,
 TIdSMTPDataReplies, TIdSyslogServer, TIdTelnetServer,
 TIdTimeServer, TIdTimeUDPServer, TIdTrivialFTPServer,
 TIdTunnelMaster, TIdTunnelSlave,
//   Indy Intercepts
 TIdBlockCipherIntercept, TIdConnectionIntercept,
 TIdCompressionIntercept, TIdLogDebug, TIdLogEvent,
 TIdLogFile, TIdLogStream,
//   Indy I/O Handlers
 TIdIOHandlerSocket, TIdSocksInfo, TIdIOHandlerStream,
 TIdIOHandlerThrottle, TIdServerIOHandlerSocket,
 TIdServerIOHandlerSSL, TIdSSLOptions, TIdSSLIOHandlerSocket,
//   Indy Misc
 TIdSocksInfo, TIdAntiFreeze, TIdCookieManager,
 TIdEncoderMIME, TIdEncoderUUE, TIdEncoderQuotedPrintable,
 TIdDateTimeStamp, TIdDecoderMIME, TIdDecoderUUE,
 TIdDecoderXXE, TIdDecoderQuotedPrintable,
 TIdIPWatch, TIdHL7, TIdMailBox, TIdMessage, TIdEMailAddressList,
 TIdEMailAddressItem, TIdMessageDecoderMIME, TIdNetworkCalculator,
 TIpProperty, TIdSysLogMessage, TIdSysLogMsgPart, TIdThreadComponent,
 TIdThreadMgrDefault, TIdThreadMgrPool, TIdUserManager,
 TIdVCard, TIdVCardName, TIdVCardEMailAddresses, TIdVCardTelephones,
 TIdVCardBusinessInfo, TIdVCardAddresses, TIdVCardMailingLabels,
 TIdVCardEmbeddedObject,

 // ===================
 //   COM+
 TCOMAdminCatalog,
 {ComObj}
 TAutoIntfObject, TAutoObject, TAutoObjectFactory, TComClassManager,
 TComObject, TComObjectFactory, TComServerObject, TTypedComObject,
 TTypedComObjectFactory,

 // ===================
 //   InterBase Admin
 TIBConfigService, TIBBackupService, TIBRestoreService,
 TIBValidationService, TIBStatisticalService, TIBLogService,
 TIBSecurityService, TIBServerProperties, TIBLicensingService,
 TIBInstall, TIBUnInstall, TInstallOptions,

 // ===================
 //   Servers
 TWordApplication, TWordDocument, TWordFont,
 TWordLetterContent, TWordParagraphFormat,
 TExcelApplication, TExcelQueryTable, TExcelChart,
 TExcelWorksheet, TExcelWorkbook, TExcelOLEObject,
 TPowerPointApplication, TPowerPointSlide,
 TPowerPointPresentation, TMaster,
 TOutlookApplication, TContactItem, TDistListItem,
 TDocumentItem, TExplorers, TInspectors, TFolders,
 TItems, TJournalItem, TNameSpace, TOutlookBarGroups,
 TOutlookBarPane, TOutlookBarShortcuts,
 TPostItem, TRemoteItem, TReportItem,
 TTaskRequestAcceptItem, TTaskRequestDeclineItem,
 TTaskRequestItem, TTaskRequestUpdateItem, TSyncObject,
 TAccessApplication, TAccessForm, TAccessReport,
 TAccessReferences, TClass_, TBinder,

 // ===================
 // ===================
// UNITS  DesignIntf, DesignEditors,
{
 TBoolProperty, TFloatProperty, TOrdinalProperty,  TIntegerProperty,
 TEnumProperty, TCharProperty, TStringProperty,  TDateProperty,
 TTimeProperty, TSetElementProperty, TSetProperty, TClassProperty,
 TComponentProperty, TComponentNameProperty, TMethodProperty,
 TPropertyEditor,
 }
 // UNITS DesignIntf, DesignEditors,
 {
 TComponentEditor, TCustomModule, TDefaultEditor, TIComponentInterface,
 TIEditorInterface, TIEditReader, TIEditView, TIEditWriter,
 TIExpert, TIFileStream, TIFormInterface, TIMainMenuIntf,
 TIMemoryStream, TIMenuItemIntf, TIModuleCreator, TIModuleInterface,
 TIModuleNotifier, TInterface, TIProjectCreator, TIResourceEntry,
 TIResourceFile, TIStreamAdapter, TIToolServices, TVirtualStream,
}
// ===================
TWinSocketStream );

// ======================================================================
//   RqTree ,    RqClass
function SeekClassNode (RqTree : TTreeView; RqClass: TClass): TTreeNode;

//   ,    RqTree
procedure MakeClassTree(RqTree        : TTreeView;
                        RqProgressBar : TProgressBar);

// ======================================================================
implementation
// ======================================================================
// =========================================================================
//   (TTreeView)      ClassArray
// =========================================================================
//   RqTree ,    RqClass
function SeekClassNode (RqTree : TTreeView; RqClass: TClass): TTreeNode;
var wNode : TTreeNode;
begin
  //      
  Result := nil;                   //  -   
  with RqTree do
  begin
    wNode := Items.GetFirstNode;   //   
    while wNode <> nil do
    begin
       if wNode.Data = pointer(RqClass) then
       begin
          //       
          //     (RqClass).  
          Result := wNode;
          Exit;
       end;
       wNode := wNode.GetNext;     //   
    end;
  end;  // of with RqTree
end;

//   RqTree      RqClass.
function AddClassNode (RqTree : TTreeView;  RqClass: TClass): TTreeNode;
var ParentNode: TTreeNode;
begin
  //  ,    RqClass
  Result := SeekClassNode (RqTree, RqClass);
  with RqTree do
  begin
    if Result = nil then
    //   RqClass  ,   
    begin
       //   ,   
       // .      
       //  SeekClassNode,    
       //  AddChildObject.
       ParentNode := AddClassNode (RqTree, RqClass.ClassParent);
       //        
       // Result :  (TTreeNode)   
       Result := RqTree.Items.AddChildObject (
                ParentNode,          //   
                RqClass.ClassName,   //   
                Pointer (RqClass));  //    
    end;
  end;
end;

//   ,    RqTree
procedure MakeClassTree(RqTree        : TTreeView;
                        RqProgressBar : TProgressBar);
var Ind : integer;
begin
  RqProgressBar.Min := Low (ClassArray);
  RqProgressBar.Max := High (ClassArray);
  //      TObject
  RqTree.Items.AddObject (nil, 'TObject', Pointer (TObject));
  //         ClassArray
  for Ind := Low (ClassArray) to High (ClassArray) do
  begin
     //     
     AddClassNode (RqTree, ClassArray [Ind]);
     RqProgressBar.Position := Ind;
  end;
  RqProgressBar.Position := RqProgressBar.Min;
end;

// ======================================================================
// ======================================================================
end.
